<?php

require_once("../../loader.php");

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$created_date = cdp_sanitize($_REQUEST['created_date']);
$expense_title = intval($_REQUEST['expense_title']);
$expense_type = intval($_REQUEST['expense_type']);
$pre_user = intval($_REQUEST['pre_user']);
$expense_amount = intval($_REQUEST['expense_amount']);
$id = intval($_REQUEST['id']);

$sWhere = "";

// // pagination variables
$page = (isset($_REQUEST['page']) && !empty($_REQUEST['page'])) ? $_REQUEST['page'] : 1;
$per_page = 10; //how much records you want to show
$adjacents  = 4; //gap between pages after number of adjacents
$offset = ($page - 1) * $per_page;

$sql = "SELECT cdb_add_order.order_date as Date, cdb_add_order.currency as Income_Currency, total_order as Income, expenses_master.created_date as Expense_Date, expense_amount as Expense, expenses_master.currency as Expense_Currency 
        FROM cdb_add_order, expenses_master";

$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();

$db->cdp_query($sql . " limit $offset, $per_page");
$data = $db->cdp_registros();

$total_pages = ceil($numrows / $per_page);


$db->cdp_query('SELECT IFNULL(SUM(expense_amount),0) as total FROM expenses_master where currency="$"');
$db->cdp_execute();
$row = $db->cdp_registro();
$dexp = $row->total;

if ($numrows > 0) { ?>
	<div class="table-responsive">


		<table id="zero_config" class="table table-condensed table-hover table-striped custom-table-checkbox">
			<thead>
				<tr>

					<th><b>Expense ID</b></th>
					<th class="text-center"><b>User</b></th>
					<th class="text-center"><b>Created Date</b></th>
					<th class="text-center"><b>Expense Title</b></th>
					<th class="text-center"><b>Expense Type</b></th>
					<th class="text-center"><b>Expense Amount</b></th>
					<th class="text-center"></th>


				</tr>
			</thead>
			<tbody id="projects-tbl">


				<?php if (!$data) { ?>
					<tr>
						<td colspan="6">
							<?php echo "
				<i align='center' class='display-3 text-warning d-block'><img src='assets/images/alert/ohh_shipment.png' width='150' /></i>								
				", false; ?>
						</td>
					</tr>
				<?php } else { ?>

					<?php

					$sumador_total = 0;
					$count = 0;
					$ktotal = 0;
					$sdtotal = 0;

					foreach ($data as $row) {

						$db->cdp_query('SELECT  IFNULL(sum(expense_amount), 0) FROM expenses_master where currency ="Ksh." ');
						$ktotal = $db->cdp_registro();
						
						$db->cdp_query('SELECT  IFNULL(sum(expense_amount), 0) FROM expenses_master where currency ="$" ');
						$sdtotal = $db->cdp_registro();
						
						$db->cdp_query("SELECT currency FROM expenses_master WHERE id='" . $row->id . "'");
                        $curr = $db->cdp_registro();

						$db->cdp_execute();
						
						$sumador_total += $row->expense_amount;
						
						$sdtotal += $sdtotal;
						$ktotal += $ktotal;
						
					?>
						<tr class="card-hovera">

							<td><b><?php echo $row->id; ?></b></td>

							<td class="text-center">
								<?php echo $row->pre_user; ?>
							</td>

							<td class="text-center">
								<?php echo $row->created_date; ?>
							</td>


							<td class="text-center">
								<?php echo $row->expense_title; ?>
							</td>
							
							<td class="text-center">
								<?php echo $row->expense_type; ?>
							</td>
							
							<td class="text-center">
								<?php echo $curr->currency; ?><?php echo number_format($row->expense_amount); ?>
							</td>

						</tr>
					<?php } ?>

				<?php } ?>
			</tbody>
			<tfoot>
				<tr class="card-hover">
				    <?php
                    $db->cdp_query('SELECT IFNULL(SUM(expense_amount),0) as total FROM expenses_master where currency="Ksh."');
                    $db->cdp_execute();
                    $row = $db->cdp_registro();
                    $sum1 = $row->total;
                    ?>
					<td class="text-left"><b>TOTAL</b></td>

					<td colspan="4"><b>Ksh. <?php echo number_format($sum1); ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;USD <?php echo number_format($dexp); ?></b> </td>
					

				</tr>

			</tfoot>

		</table>

        <div class="pull-right">
			<?php echo cdp_paginate($page, $total_pages, $adjacents);	?>
		</div>

	</div>
<?php } ?>