<?php


require_once('helpers/querys.php');

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$customer_id = intval($_REQUEST['customer_id']);
$pay_mode = intval($_REQUEST['pay_mode']);
$range = $_REQUEST['range'];
$name_off=$userData->name_off;


$sWhere = "";


if ($customer_id > 0) {

    $sWhere .= " and b.sender_id = '" . $customer_id . "'";
}


if ($pay_mode > 0) {

    $sWhere .= " and a.payment_type = '" . $pay_mode . "'";
}


if (!empty($range)) {

    $fecha =  explode(" - ", $range);
    $fecha = str_replace('/', '-', $fecha);

    $fecha_inicio = date('Y-m-d', strtotime($fecha[0]));
    $fecha_fin = date('Y-m-d', strtotime($fecha[1]));


    $sWhere .= " and  a.order_date between '" . $fecha_inicio . "'  and '" . $fecha_fin . "'";
}


if ($userData->name_off == 'undefined') {
    
    $sql = "SELECT a.total_fixed_value, a.status_invoice,  a.total_order, a.order_id, a.order_prefix, a.order_no, a.order_date, a.sender_id, a.receiver_id, a.currency, a.order_courier,a.status_courier,  b.mod_style, b.color FROM
		cdb_add_order as a
		INNER JOIN cdb_styles as b ON a.status_courier = b.id
		$sWhere
		and a.status_courier!=22
		and a.currency = '$'
		order by order_id desc 
     ";
    
}else{
    
    $sql = "SELECT a.total_fixed_value, a.status_invoice,  a.total_order, a.order_id, a.order_prefix, a.order_no, a.order_date, a.sender_id, a.receiver_id, a.currency, a.order_courier,a.status_courier,  b.mod_style, b.color FROM
		cdb_add_order as a
		INNER JOIN cdb_styles as b ON a.status_courier = b.id
		INNER JOIN cdb_users as c ON a.sender_id = c.id
		INNER JOIN cdb_offices d on (a.origin_off=d.id)
		$sWhere
		and a.status_courier!=22
		and d.name_off='$name_off'
		and a.currency = '$'
		order by order_id desc 
     ";
}



$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();


$db->cdp_query($sql);
$data = $db->cdp_registros();

$fecha = str_replace('-', '/', $fecha);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="assets/<?php echo $core->favicon ?>">

    <title>Income Statement Report - USD</title>
    <link href="assets/custom_dependencies/print_report.css" rel="stylesheet">


</head>

<body>
    <div id="page-wrap">

        <h2 style="border: 0;  text-align: center">
            <?php echo ($core->logo) ? '<img src="assets/uploads/galeyr.png"/>' : $core->site_name; ?>
            <br/>
            <?php echo $core->site_name; ?><br>
            Income Statement Report - USD <br>

            [<?php echo $fecha[0] . ' - ' . $fecha[1]; ?>] <br>


        </h2>


        <table>
            <tr>
                <th><b>Tracking</b></th>
				<th class="text-center"><b><?php echo $lang['ddate'] ?></b></th>
				<th class="text-center"><b>Sender</b></th>
				<th class="text-center"><b>Fixed Charge</b></th>
				<th class="text-center"><b>Total</b></th>
				<th class="text-center"><b><?php echo $lang['lstatusshipment'] ?></b></th>
            </tr>

            <?php

            if ($numrows > 0) {

                $count = 1;
                $sumador_total = 0;

                foreach ($data as $row) {

                    $db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->sender_id . "'");
						$sender_data = $db->cdp_registro();
						
						$db->cdp_query("SELECT * FROM cdb_users where id= '" . $row->receiver_id . "'");
						$receiver_data = $db->cdp_registro();
						
						$db->cdp_query("SELECT currency FROM cdb_add_order WHERE order_id='" . $row->order_id . "'");
                        $curr = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_address_shipments where order_track='" . $row->order_prefix . $row->order_no . "'");
						$address_order = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_courier_com where id= '" . $row->order_courier . "'");
						$courier_com = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_styles where id= '14'");
						$status_style_pickup = $db->cdp_registro();

						$db->cdp_query("SELECT * FROM cdb_styles where id= '13'");
						$status_style_consolidate = $db->cdp_registro();
						
						if ($row->status_invoice == 1) {
							$text_status = $lang['invoice_paid'];
							$label_class = "label-success";
						} else if ($row->status_invoice == 2) {
							$text_status = $lang['invoice_pending'];
							$label_class = "label-warning";
						} else if ($row->status_invoice == 3) {
							$text_status = $lang['invoice_due'];
							$label_class = "label-danger";
						}
						
						$weight = $row->total_weight;
                		$sub_total = $row->sub_total;
                		$discount = $row->total_tax_discount;
                		$insurance = $row->total_tax_insurance;
                		$custom_c = $row->total_tax_custom_tariffis;
                		$tax = $row->total_tax;
                		$total_declared_tax = $row->total_declared_value;
                		$total_fixed_charge = $row->total_fixed_value;
                
                		$total = $row->total_order;
                
                		$sumador_weight += $weight;
                		$sumador_subtotal += $sub_total;
                		$sumador_discount += $discount;
                		$sumador_insurance += $insurance;
                		$sumador_c_tariff += $custom_c;
                		$sumador_tax += $tax;
                		$sumador_total += $total;
                		$sumador_declared_tax += $total_declared_tax;
                		$sumador_fixed_charge += $total_fixed_charge;

            ?>
                    <tr class="card-hover">

							<td>
							    <b><a href="courier_view.php?id=<?php echo $row->order_id; ?>"><?php echo $row->order_prefix . $row->order_no; ?></a></b>
							</td>
							<td class="text-center">
								<?php echo $row->order_date; ?>
							</td>

							<td class="text-center">
								<?php echo $sender_data->fname; ?> <?php echo $sender_data->lname; ?>
							</td>

							<td class="text-center">
								<?php echo $curr->currency; ?><?php echo number_format($row->total_fixed_value); ?>

							</td>

							<td class="text-center">
								<b><?php echo $curr->currency; ?></b> <?php echo number_format($row->total_order); ?>
							</td>

							<td>
								<span class="label label-large <?php echo $label_class; ?>"><?php echo $text_status; ?></span>

							</td>


						</tr>
                <?php

                    $count++;
                }
                ?>

                <tr>
                    <td class="text-left"><b>TOTAL</b></td>


                    <td colspan="2"></td>
                    <td class="text-left">
                        <b><?php echo $curr->currency; ?><?php echo number_format($sumador_fixed_charge); ?> </b>
                    </td>
                    <td class="text-left">
                        <b><?php echo $curr->currency; ?><?php echo number_format($sumador_total); ?> </b>
                    </td>
                </tr>
            <?php
            }
            ?>


        </table>

        <button class='button -dark center no-print' onClick="window.print();" style="font-size:16px; margin-top: 20px;">Print &nbsp;&nbsp; <i class="fa fa-print"></i></button>
    </div>

</body>

</html>