<?php

require_once("../../loader.php");

$db = new Conexion;
$user = new User;
$core = new Core;
$userData = $user->cdp_getUserData();

$created_date = cdp_sanitize($_REQUEST['created_date']);
$expense_title = intval($_REQUEST['expense_title']);
$expense_type = intval($_REQUEST['expense_type']);
$pre_user = intval($_REQUEST['pre_user']);
$expense_amount = intval($_REQUEST['expense_amount']);
$id = intval($_REQUEST['id']);

$range = cdp_sanitize($_REQUEST['range']);

$sWhere = "";


if (!empty($range)) {

    $fecha =  explode(" - ", $range);
    $fecha = str_replace('/', '-', $fecha);

    $fecha_inicio = date('Y-m-d', strtotime($fecha[0]));
    $fecha_fin = date('Y-m-d', strtotime($fecha[1]));


    $sWhere .= " created_date between '" . $fecha_inicio . "'  and '" . $fecha_fin . "'";
}


$sql = "SELECT * FROM expenses_master $sWhere";

$query_count = $db->cdp_query($sql);
$db->cdp_execute();
$numrows = $db->cdp_rowCount();

$db->cdp_query($sql);
$data = $db->cdp_registros();

$fecha = str_replace('-', '/', $fecha);

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">

<head>
    <meta http-equiv='Content-Type' content='text/html; charset=UTF-8' />
    <meta name="msapplication-TileColor" content="#ffffff">
    <meta name="theme-color" content="#ffffff">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <!-- Tell the browser to be responsive to screen width -->
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="description" content="">
    <meta name="author" content="">
    <!-- Favicon icon -->
    <link rel="icon" type="image/png" sizes="16x16" href="assets/<?php echo $core->favicon ?>">

    <title>Expenses Report</title>

    <link href="assets/custom_dependencies/print_report.css" rel="stylesheet">

</head>

<body>
    <div id="page-wrap">

        <h2 style="border: 0;  text-align: center">
            <?php echo ($core->logo) ? '<img src="assets/uploads/galeyr.png"/>' : $core->site_name; ?>
            <br/>
            <?php echo $core->site_name; ?><br>
            Expenses Report <br>
        
            [<?php echo $fecha[0] . ' - ' . $fecha[1]; ?>] <br>


        </h2>


        <table style="border: 0;  text-align: center">
            <tr>

                <th><b>Expense ID</b></th>
				<th class="text-center"><b>User</b></th>
				<th class="text-center"><b>Created Date</b></th>
				<th class="text-center"><b>Expense Title</b></th>
				<th class="text-center"><b>Expense Type</b></th>
				<th class="text-center"><b>Expense Amount</b></th>


            </tr>

            <?php

            if ($numrows > 0) {

                $count = 1;
                $sumador_pendiente = 0;
                $sumador_total = 0;
                $sumador_pagado = 0;

                foreach ($data as $row) {

					$count = 0;

					foreach ($data as $row) {

						$db->cdp_query('SELECT * FROM expenses_master');
						$expense_data = $db->cdp_registro();
						
						$db->cdp_query("SELECT currency FROM expenses_master WHERE id='" . $row->id . "'");
                        $curr = $db->cdp_registro();

            ?>
                    <tr class="card-hovera">

							<td><b><?php echo $expense_data->id; ?></b></td>

							<td class="text-center">
								<?php echo $expense_data->pre_user; ?>
							</td>

							<td class="text-center">
								<?php echo $expense_data->created_date; ?>
							</td>

							<td class="text-center">
								<?php echo $expense_data->expense_title; ?>
							</td>
							
							<td class="text-center">
								<?php echo $expense_data->expense_type; ?>
							</td>
							
							<td class="text-center">
								<?php echo $curr->currency; ?><?php echo number_format($expense_data->expense_amount); ?>
							</td>

						</tr>
                <?php

                    $count++;
                }
                ?>

            <?php
            }
            ?>


        </table>

        <button class='button -dark center no-print' onClick="window.print();" style="font-size:16px; margin-top: 20px;">Print &nbsp;&nbsp; <i class="fa fa-print"></i></button>
    </div>

</body>

</html>